'use strict';


const moment = require('moment');

module.exports = app => {
  const { STRING, INTEGER, DATE, ENUM } = app.Sequelize;

  const CourseBanner = app.classModel.define('course_banner', {
    id: {
      type: INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    type_id: INTEGER,
    title: STRING,
    url: STRING,
    sort: INTEGER,
    status: ENUM('offline', 'online'),
    is_deleted: INTEGER,
    created_time: {
      type: DATE,
      allowNull: true,
      get() {
        const date = this.getDataValue('created_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
    updated_time: {
      type: DATE,
      allowNull: true,
      get() {
        const date = this.getDataValue('updated_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
  }, {
    timestamps: false,
    tableName: 'course_banner',
  });

  return CourseBanner;

};
