'use strict';

const moment = require('moment');

module.exports = app => {
    const { STRING, INTEGER, DATE } = app.Sequelize;
    const CdPresellSearchHistory = app.realestateModel.define('cd_presell_search_history', {
        id: {
            type: INTEGER,
            allowNull: false,
            primaryKey: true,
            autoIncrement: true,
        },
        user_id: {
            type: STRING,
            allowNull: true
        },
        app_user_id: {
            type: STRING,
            allowNull: true
        },
        app_id: {
            type: STRING,
            allowNull: true
        },
        app_type_id: {
            type: STRING,
            allowNull: true
        },
        key_word: {
            type: STRING,
            allowNull: true
        },
        state: {
            type: INTEGER,
            allowNull: true
        },
        created_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('created_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        updated_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('updated_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        deleted_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('deleted_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },

    }, {
            timestamps: false,
            tableName: 'cd_presell_search_history',
        });

    return CdPresellSearchHistory;

};
