'use strict';

const moment = require('moment');

module.exports = app => {
  const { INTEGER, STRING, DATE } = app.Sequelize;
  const HuayunPaasCallOut = app.prometheusModel.define('huayun_paas_callout', {
    id: { type: INTEGER, primaryKey: true, autoIncrement: true },
    session_id: STRING,
    start_time: {
      type: DATE,
      get() {
        const date = this.getDataValue('start_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
    end_time: {
      type: DATE,
      get() {
        const date = this.getDataValue('end_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
    remote_url: STRING,
    local_url: STRING,
    duretion: STRING,
    end_type: STRING,
    agent_id: STRING,
    call_type: STRING,
    r_start_time: {
      type: DATE,
      get() {
        const date = this.getDataValue('r_start_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
    r_end_time: {
      type: DATE,
      get() {
        const date = this.getDataValue('r_end_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
    c_ivr_key: STRING,
    path: STRING,
    record_nama: STRING,
    created_at: {
      type: DATE,
      get() {
        const date = this.getDataValue('created_at');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    }
  }, {
      timestamps: false,
      tableName: 'huayun_paas_callout',
    });

  HuayunPaasCallOut.one = async (data) => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    return await HuayunPaasCallOut.findOne({
      attributes: attributes,
      where: where,
    });
  }


  HuayunPaasCallOut.all = async (data) => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    return await HuayunPaasCallOut.findAll({
      attributes: attributes,
      where: where,
    });
  }

  HuayunPaasCallOut.list = async (data = {}) => {
    const limit = data.limit ? data.limit : 10;
    const page = data.page ? data.page : 1;
    const order = data.order ? data.order : [];
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    const condition = {
      offset: (page - 1) * limit,
      limit,
      where: where,
      order: order,
      attributes: attributes,
    };
    const { count, rows } = await HuayunPaasCallOut.findAndCountAll(condition);
    return { page, count, rows };
  }

  HuayunPaasCallOut.add = async (data) => {
    try {
      //返回promise对象实力 instance 
      const res = await HuayunPaasCallOut.create(data);
      //从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
      return res.id;
    } catch (error) {
      throw (error);
    }
  }

  HuayunPaasCallOut.edit = async (data) => {
    const where = data.where;
    const params = data.params;
    try {
      const res = await HuayunPaasCallOut.update(params, { where: where })
      return res;
    } catch (error) {
      throw (error);
    }
  }

  return HuayunPaasCallOut;

};
