'use strict';

module.exports = app => {
  const { INTEGER, STRING, TEXT } = app.Sequelize;

  const Setting = app.huodongModel.define('cfg_setting', {
    setting_id: { type: INTEGER, primaryKey: true, autoIncrement: true },
    code: STRING(32),
    keyword: STRING(64),
    value: TEXT,
    is_json: INTEGER(2),
  }, {
    timestamps: false,
    tableName: 'cfg_setting',
  });

  Setting.one = async (data) => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
      return await Setting.findOne({
          attributes: attributes,
          where : where,
      });
  }

  return Setting;

};
