'use strict';


const moment = require('moment');

module.exports = app => {
  const { STRING, INTEGER, DATE } = app.Sequelize;

  const CourseV5ReportColumnDetail = app.classModel.define('course_v5_report_column_detail', {
    id: {
      type: INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    report_column_id: INTEGER,
    sub_title: STRING,
    level: INTEGER,
    content: STRING,
    advice: STRING,
    status: INTEGER,
    is_deleted: INTEGER,
    number: INTEGER,
    created_time: {
      type: DATE,
      allowNull: true,
      get() {
        const date = this.getDataValue('created_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
    updated_time: {
      type: DATE,
      allowNull: true,
      get() {
        const date = this.getDataValue('updated_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
  }, {
    timestamps: false,
    tableName: 'course_v5_report_column_detail',
  });

  return CourseV5ReportColumnDetail;

};
