// navbar 上面的用户名 下拉选项功能
import React, { useState, useEffect } from 'react';
import { Menu, Dropdown, Modal, Input, message, Button } from 'antd';
import { DownOutlined } from '@ant-design/icons';
import { api } from '../common/fetch';

const AccountName: React.FC = () => {
  const [pwdModal, set_pwdModal] = useState(false);
  const [logout, set_logout] = useState(false);
  const [confirm_password, set_confirm_password] = useState('');
  const [password, set_password] = useState('');
  const [o_pwd, set_o_pwd] = useState('');
  const [user, set_user] = useState('');

  useEffect(() => {
    set_user(window.localStorage.getItem('user') as string);
  }, []);

  const { Item } = Menu;
  const menu = (
    <Menu>
      {/* <Item onClick={() => set_logout(true)}>修改密码</Item> */}
      <Item onClick={() => set_pwdModal(true)}>退出登录</Item>
    </Menu>
  );

  const handleOk = () => {
    window.localStorage.removeItem('user');
    window.localStorage.removeItem('token');
    set_pwdModal(false);
    window.localStorage.removeItem('routerConf');
    window.location.href = '/inclass-partners/login';
  };

  const logoutOk = () => {
    if (o_pwd && password && confirm_password) {
      if (confirm_password === password) {
        changePwd();
      } else {
        message.error('密码不一致');
      }
    } else {
      message.info('输入框不能为空');
    }
  };

  const changePwd = () => {
    api('/yizhi_server/api/user/password', {
      type: 'PUT',
      data: {
        password: password,
        confirm_password: confirm_password
      }
    }).then(r => {
      if (r.msg) {
        if (r.msg.match(/成功/)) {
          message.info(`${r.msg}，请重新登录`);
          set_pwdModal(false);
          setTimeout(() => {
            handleOk();
          }, 1000);
        } else {
          message.info(r.msg);
        }
      }
    });
  };

  const onChange = (e: any, type: string) => {
    const v = e.target.value;
    let obj: any = {
      o_pwd: () => set_o_pwd(v),
      password: () => set_password(v),
      confirm_password: () => set_confirm_password(v)
    };
    obj[type]();
  };
  return (
    <>
      <Dropdown overlay={menu}>
        <Button type="link">
          {user} <DownOutlined />
        </Button>
      </Dropdown>
      <Modal
        title=""
        width="300px"
        visible={pwdModal}
        onOk={handleOk}
        onCancel={() => set_pwdModal(false)}
      >
        <p style={{ fontSize: '18px' }}>是否退出登录？</p>
      </Modal>

      <Modal
        title="修改密码"
        width="400px"
        visible={logout}
        onOk={logoutOk}
        onCancel={() => set_logout(false)}
      >
        <div>
          <Input
            size="large"
            placeholder="请输入你的原密码"
            addonBefore="原密码"
            defaultValue=""
            autoComplete="off"
            onChange={(e: any) => onChange(e, 'o_pwd')}
          />
          <div style={{ height: '20px' }} />
          <Input.Password
            size="large"
            placeholder="请输入你的新密码"
            addonBefore="新密码"
            defaultValue=""
            autoComplete="new-password"
            onChange={(e: any) => onChange(e, 'password')}
          />
          <div style={{ height: '20px' }} />
          <Input.Password
            size="large"
            defaultValue=""
            autoComplete="new-password"
            placeholder="请再次输入你的新密码"
            addonBefore="确认新密码"
            onChange={(e: any) => onChange(e, 'confirm_password')}
          />
        </div>
      </Modal>
    </>
  );
};

export default AccountName;
