import React from 'react';
import { Table } from 'antd';
const { Column } = Table;

interface DeatilI {
  id: string | number;
  class_name: string | number;
  code: string | number;
  channel: string | number;
  is_used: string | number;
  phone: string | number;
  used_time: string;
}

interface ColsI {
  title: string;
  dataIndex: string;
  key: string | number;
}

interface DataSourceI {
  dataSource: DeatilI[];
  pageSize: number;
  current: number;
  totalCount: number;
  handleTableChange: any;
}

const columns = [
  {
    title: '订单号',
    dataIndex: 'order_no',
    key: 'order_no'
  },
  {
    title: '兑换课程名称',
    dataIndex: 'class_name',
    key: 'class_name'
  },
  {
    title: '兑换码',
    dataIndex: 'code',
    key: 'code'
  },
  {
    title: '渠道',
    dataIndex: 'channel',
    key: 'channel'
  },
  {
    title: '兑换授权手机号',
    dataIndex: 'phone',
    key: 'phone'
  },
  {
    title: '是否兑换',
    dataIndex: 'is_used',
    key: 'is_used',
    render: (row: any) => {
      return <span>{row ? '是' : '否'}</span>;
    }
  },
  {
    title: '兑换时间',
    dataIndex: 'used_time',
    key: 'used_time'
  }
];

const Cols = (list: ColsI[]) => {
  return list.map((item: any) => {
    return <Column {...item} key={item.key} />;
  });
};

const List: React.FC<DataSourceI> = props => {
  return (
    <div style={{ padding: '30px' }}>
      <Table
        rowKey={record => record.id || 'key'}
        dataSource={props.dataSource}
        onChange={props.handleTableChange}
        pagination={{
          pageSize: props.pageSize,
          current: props.current,
          total: props.totalCount,
          showSizeChanger: true,
          showTotal: (total, range) =>
            `每页${range[1] - range[0] + 1}条，总计${total} 条`
        }}
      >
        {Cols(columns)}
      </Table>
    </div>
  );
};

export default List;
