import React, { useState, useEffect } from 'react';
import { Input, Button, Form, Row, Col } from 'antd';
import { Link } from 'react-router-dom';

import List from './list';
import excelFn from '../../common/excel';
import { api } from '../../common/fetch';
import BasicPage from '../../layout/basicPage';
// style
import './index.scss';

const FormItem = Form.Item;
const PAGE_SIZE = 10;

const ExchangeCode: React.FC = () => {
  const [courseName, set_courseName] = useState('');
  const [current, set_current] = useState(1);
  const [pageSize, set_pageSize] = useState(PAGE_SIZE);

  useEffect(() => {
    getList(courseName, current, pageSize);
  }, []);

  const getList = (courseName: string, current: number, pageSize: number) => {
    api(`/yizhi_server/api/account/analyse`, {
      type: 'GET',
      data: {
        courseName: courseName,
        pageSize: pageSize,
        page: current
      }
    }).then(r => {
      console.log(r);
    });
  };

  const download = () => {
    api('/yizhi_server/api/account/analyse/download', {
      type: 'GET',
      data: {
        product: 'JSON.stringify(info.product)'
      },
      responseType: 'arrayBuffer'
    }).then(r => {
      excelFn(r, `分析明细`);
    });
  };

  const submitData = () => {
    getList(courseName, 1, pageSize);
  };

  const resetData = () => {
    // set_current(1);
    // set_pageSize(pageSize);
    // set_courseName('');
    getList('', 1, pageSize);
  };

  const handleTableChange = (args: any) => {
    // set_current(args.current);
    // set_pageSize(args.pageSize);
    getList(courseName, args.current, args.pageSize);
  };

  let dataSource = [];
  for (let i = 0; i < 25; i++) {
    dataSource.push({
      id: i,
      courseName: '我都唔',
      code: 'woeopwr',
      status: 1,
      date: '2020-05-20'
    });
  }

  return (
    <BasicPage>
      <div className="content">
        <Row {...{ gutter: { xs: 8, sm: 16, md: 24 } }}>
          <Col md={6} sm={12}>
            <FormItem label="已购课程名称：">
              <Input
                value={courseName}
                placeholder="请输入"
                onChange={e => {
                  set_courseName(e.target.value);
                }}
              />
            </FormItem>
          </Col>
          <Col md={6} sm={12}>
            <Button
              type="primary"
              onClick={submitData}
              style={{ marginRight: '12px' }}
            >
              查询
            </Button>
            <Button htmlType="button" onClick={resetData}>
              重置
            </Button>
          </Col>
        </Row>
        <Row
          style={{ padding: '12px 0' }}
          {...{ gutter: { xs: 8, sm: 16, md: 24 } }}
        >
          <Col md={12} sm={24}>
            <Button type="primary" style={{ marginRight: '12px' }}>
              <Link to="/generateCode">兑换码生成器</Link>
            </Button>
            <Button
              type="primary"
              style={{ marginRight: '12px' }}
              onClick={download}
            >
              导出兑换码数据表
            </Button>
          </Col>
        </Row>
      </div>
      <List
        dataSource={dataSource}
        handleTableChange={handleTableChange}
        pageSize={pageSize}
        current={current}
      />
    </BasicPage>
  );
};

export default ExchangeCode;
