import React, { useEffect, useState } from 'react';
import { Layout } from 'antd';
import AccountName from './accountName';
import SiderMenu from './siderMenu';
import './index.scss';

import { MenuUnfoldOutlined, MenuFoldOutlined } from '@ant-design/icons';

const { Header, Footer, Content } = Layout;

// 如果没有相应的登录校验跳转login页面
const Login: React.FC = () => {
  useEffect(() => {
    window.location.href = '/inclass/login';
  }, []);
  return null;
};

interface BasicPageI {
  children: any;
  config?: any;
}

// 基本的 layout 布局
const BasicPage: React.FC<BasicPageI> = props => {
  const [collapsed, set_collapse] = useState(false);
  const [menuWidth, set_menuWidth] = useState(200);
  const token = sessionStorage.getItem('token') || 888;
  const toggle = () => {
    set_menuWidth(collapsed ? 200 : 80);
    set_collapse(!collapsed);
  };
  if (token) {
    return (
      <Layout style={{ minHeight: '100vh' }}>
        <SiderMenu
          collapsed={collapsed}
          style={{
            overflow: 'auto',
            height: '100vh',
            position: 'fixed',
            left: 0,
            width: menuWidth
          }}
        />
        <Layout
          className="site-layout"
          style={{
            paddingLeft: menuWidth
          }}
        >
          <Header className="site-layout-background">
            {React.createElement(
              collapsed ? MenuUnfoldOutlined : MenuFoldOutlined,
              {
                className: 'trigger',
                onClick: toggle
              }
            )}
            <AccountName />
          </Header>
          <Content
            style={{ padding: '50px 20px', marginTop: 20, background: '#fff' }}
          >
            {props.children}
          </Content>
          <Footer>
            <div style={{ textAlign: 'center' }}>
              <p>©2020 - 趣选课</p>
              <p>如有问题，请联系技术</p>
            </div>
          </Footer>
        </Layout>
      </Layout>
    );
  } else {
    return <Login />;
  }
};
export default BasicPage;
