import React, { useState, useEffect } from 'react';
import { Layout, Menu } from 'antd';
import { Link } from 'react-router-dom';

import { PieChartOutlined, UserOutlined } from '@ant-design/icons';

const { Sider } = Layout;
const { SubMenu } = Menu;

interface ConfigI {
  collapsed: boolean;
  style?: any;
}

const MenuBar: React.FC<ConfigI> = props => {
  const [defKey, set_defKey] = useState('1');
  const [openKey, set_openKey] = useState('');

  useEffect(() => {
    let menu_defKey = window.sessionStorage.getItem('menu_defKey') || '1';
    let menu_openKey = window.sessionStorage.getItem('menu_openKey') || '1';
    // console.log('menu_defKey', menu_defKey);
    // console.log('menu_openKey', menu_openKey);
    set_defKey(menu_defKey);
    set_openKey(menu_openKey);
  }, []);

  const routerConf = [
    {
      key: '1',
      title: '订单列表',
      path: '/orderList',
      icon: <PieChartOutlined />
    },
    {
      key: '2',
      title: '兑换码',
      path: '',
      icon: <UserOutlined />,
      subs: [
        {
          key: '3',
          title: '兑换码列表',
          path: '/exchangeCode',
          icon: ''
        },
        {
          key: '4',
          title: '兑换码生成',
          path: '/generateCode',
          icon: ''
        }
      ]
    }
  ];

  const CreateItem = (item: any) => {
    return (
      <Menu.Item key={item.key} icon={item.icon}>
        <Link to={item.path}>{item.title}</Link>
      </Menu.Item>
    );
  };

  const GererateRouter = () => {
    return routerConf.map(item => {
      if (item.subs && item.subs.length > 0) {
        return (
          <SubMenu key={item.key} icon={item.icon} title={item.title}>
            {item.subs.map(idx => CreateItem(idx))}
          </SubMenu>
        );
      } else {
        return CreateItem(item);
      }
    });
  };

  const handleClick = (data: any) => {
    set_defKey(data.key);
    let keyPath = data.keyPath[data.keyPath.length - 1];
    set_openKey(keyPath);
    window.sessionStorage.setItem('menu_defKey', data.key);
    window.sessionStorage.setItem('menu_openKey', keyPath);
  };

  return (
    <>
      <Sider
        trigger={null}
        collapsible
        collapsed={props.collapsed}
        className="sider-menu"
        style={props.style}
      >
        {props.collapsed ? null : (
          <div className="menu-header">
            <Link to="/orderList" className="home">
              <img
                className="logo"
                src="//r.51gjj.com/webpublic/images/2020523/oyed3Mkrvrpdg.png"
                alt=""
              />
              <div className="title">趣选课合作后台</div>
            </Link>
          </div>
        )}
        <Menu
          theme="dark"
          defaultSelectedKeys={[defKey]}
          // defaultOpenKeys={['2']}
          defaultOpenKeys={[openKey]}
          selectedKeys={[defKey]}
          mode="inline"
          onClick={handleClick}
        >
          {GererateRouter()}
        </Menu>
      </Sider>
    </>
  );
};
export default MenuBar;
