import React from 'react'
interface IObjectStringKeys {
  [key: string]: IColumnsValue;
}
interface IColumnsValue {
  title: string;
  dataIndex: string;
  key: string | number;
  render?: Function
}
const TableColumnsSetting: IObjectStringKeys = {
  order_no: {
    title: '订单号',
    dataIndex: 'order_no',
    key: 'order_no'
  },
  class_name: {
    title: '已购课程名称',
    dataIndex: 'class_name',
    key: 'class_name'
  },
  name: {
    title: '用户姓名',
    dataIndex: 'address',
    key: 'name',
    render: (row: any) => {
      return <span>{row.name}</span>;
    }
  },
  address: {
    title: '收货地址',
    dataIndex: 'address',
    key: 'address',
    render: (row: any) => {
      return (
        <span>
          {row.province}
          {row.city}
          {row.area}
          {row.address}
        </span>
      );
    }
  },
  phone: {
    title: '联系电话',
    dataIndex: 'address',
    key: 'phone',
    render: (row: any) => {
      return <span>{row.phone}</span>;
    }
  },
  pay: {
    title: '付款金额（元）',
    dataIndex: 'pay',
    key: 'pay'
  },
  pay_time: {
    title: '下单时间',
    dataIndex: 'pay_time',
    key: 'pay_time'
  }
}

export default TableColumnsSetting