import React, { useState } from 'react';
import { Layout, Menu } from 'antd';
import { Link } from 'react-router-dom';

import { PieChartOutlined, UserOutlined } from '@ant-design/icons';

const { Sider } = Layout;
const { SubMenu } = Menu;

interface ConfigI {
  collapsed: boolean;
  style?: any;
}

const MenuBar: React.FC<ConfigI> = props => {
  const [defKey, set_defKey] = useState('1');

  const routerConf = [
    {
      path: '/orderList',
      title: '订单列表',
      key: '1',
      icon: <PieChartOutlined />
    },
    {
      title: '兑换码',
      path: '',
      key: 'sub1',
      icon: <UserOutlined />,
      subs: [
        {
          key: '2',
          path: '/exchangeCode',
          title: '兑换码列表',
          icon: ''
        },
        {
          key: '3',
          path: '/generateCode',
          title: '兑换码生成',
          icon: ''
        }
      ]
    }
  ];

  const CreateItem = (item: any) => {
    return (
      <Menu.Item key={item.key} icon={item.icon}>
        <Link to={item.path}>{item.title}</Link>
      </Menu.Item>
    );
  };

  const GererateRouter = () => {
    return routerConf.map(item => {
      if (item.subs && item.subs.length > 0) {
        return (
          <SubMenu key={item.key} icon={item.icon} title={item.title}>
            {item.subs.map(idx => CreateItem(idx))}
          </SubMenu>
        );
      } else {
        return CreateItem(item);
      }
    });
  };

  const handleClick = (data: any) => {
    set_defKey(data.key);
  };

  return (
    <>
      <Sider
        trigger={null}
        collapsible
        collapsed={props.collapsed}
        className="sider-menu"
        style={props.style}
      >
        {props.collapsed ? null : (
          <div className="menu-header">
            <Link to="/orderList" className="home">
              <img
                className="logo"
                src="//r.51gjj.com/webpublic/images/2020523/oyed3Mkrvrpdg.png"
                alt=""
              />
              <div className="title">趣选课合作后台</div>
            </Link>
          </div>
        )}
        <Menu
          theme="dark"
          defaultSelectedKeys={['1']}
          selectedKeys={[defKey]}
          mode="inline"
          onClick={handleClick}
        >
          {GererateRouter()}
        </Menu>
      </Sider>
    </>
  );
};
export default MenuBar;
