import React, { useState } from 'react';
import moment from 'moment';
import { Input, Button, Form, Row, Col } from 'antd';
import { Link } from 'react-router-dom';
import 'moment/locale/zh-cn';
import BasicPage from '../../layout/basicPage';
import List from './list';

// import { api } from '../../common/fetch';
// style
import './index.scss';

const FormItem = Form.Item;
moment.locale('zh-cn');

const Order: React.FC = () => {
  const [courseName, set_courseName] = useState('');

  const [form] = Form.useForm();

  console.log(courseName);
  // useEffect(() => {}, []);

  const formItemLayout = {
    labelCol: {
      xs: { span: 24 },
      sm: { span: 10 },
      md: { span: 10 }
    },
    wrapperCol: {
      xs: { span: 24 },
      sm: { span: 16 },
      md: { span: 16 }
    }
  };

  const download = () => {
    console.log('xiazai');
  };

  const onFinish = (values: any) => {
    for (let i in values) {
      if (!values[i]) delete values[i];
    }
    console.log('Success:', values);
  };

  const onFinishFailed = (errorInfo: any) => {
    console.log('Failed:', errorInfo);
  };

  const resetData = () => {
    form.resetFields();
    set_courseName('');
  };

  const handleTableChange = (args: any) => {
    console.log(args);
  };

  let dataSource = [];
  for (let i = 0; i < 25; i++) {
    dataSource.push({
      id: i,
      courseName: '我都唔',
      code: 'woeopwr',
      status: 1,
      date: '2020-05-20'
    });
  }

  return (
    <BasicPage>
      <div className="analy-content">
        <Form
          {...formItemLayout}
          form={form}
          onFinish={onFinish}
          onFinishFailed={onFinishFailed}
        >
          <Row {...{ gutter: { xs: 8, sm: 16, md: 24 } }}>
            <Col>
              <FormItem label="已购课程名称：" name="courseName">
                <Input
                  placeholder="请输入"
                  onChange={e => {
                    set_courseName(e.target.value);
                  }}
                />
              </FormItem>
            </Col>
            <Col md={12} sm={24}>
              <Form.Item>
                <Button
                  type="primary"
                  htmlType="submit"
                  style={{ marginRight: '12px' }}
                >
                  查询
                </Button>
                <Button htmlType="button" onClick={resetData}>
                  重置
                </Button>
              </Form.Item>
            </Col>
          </Row>
          <Row
            style={{ padding: '12px 0' }}
            {...{ gutter: { xs: 8, sm: 16, md: 24 } }}
          >
            <Col md={12} sm={24}>
              <Button type="primary" style={{ marginRight: '12px' }}>
                <Link to="/generateCode">兑换码生成器</Link>
              </Button>
              <Button
                type="primary"
                style={{ marginRight: '12px' }}
                onClick={download}
              >
                导出兑换码数据表
              </Button>
            </Col>
          </Row>
        </Form>
      </div>
      <List dataSource={dataSource} handleTableChange={handleTableChange} />
    </BasicPage>
  );
};

export default Order;
