import React, { useState } from 'react';
import BasicPage from '../../layout/basicPage';
import locale from 'antd/es/date-picker/locale/zh_CN';
import moment from 'moment';
import List from './list';
// import excelFn from '../../common/excel';
import { Input, Button, Form, DatePicker, Row, Col } from 'antd';
import 'moment/locale/zh-cn';

// import { api } from '../../common/fetch';
// style
import './index.scss';

const FormItem = Form.Item;
const { RangePicker } = DatePicker;
moment.locale('zh-cn');

const Order: React.FC = () => {
  const [courseName, set_courseName] = useState('');
  const [userName, set_userName] = useState('');
  const [dates, setDates] = useState([] as any);

  console.log(courseName, userName, dates);
  const [form] = Form.useForm();

  // useEffect(() => {}, []);

  const formItemLayout = {
    labelCol: {
      xs: { span: 24 },
      sm: { span: 10 },
      md: { span: 10 }
    },
    wrapperCol: {
      xs: { span: 24 },
      sm: { span: 16 },
      md: { span: 16 }
    }
  };

  const download = () => {
    console.log('xiazai');
    // excelFn()
  };

  const onFinish = (values: any) => {
    for (let i in values) {
      if (!values[i]) delete values[i];
      if (values[i] && Array.isArray(values[i]) && values[i].length === 2) {
        let date = values[i];
        values.start_time = moment(date[0]).format('YYYY-MM-DD');
        values.end_time = moment(date[1]).format('YYYY-MM-DD');
        delete values[i];
      }
    }
    console.log('Success:', values);
  };

  const onFinishFailed = (errorInfo: any) => {
    console.log('Failed:', errorInfo);
  };

  const resetData = () => {
    form.resetFields();
    set_courseName('');
    set_userName('');
    setDates([]);
  };

  const handleTableChange = (args: any) => {
    console.log(args);
  };

  let dataSource = [];
  for (let i = 0; i < 25; i++) {
    dataSource.push({
      id: i,
      orderNumber: 7878,
      courseName: '我都唔',
      userName: 'woeopwr',
      address: '前五位哦',
      phone: 15180356828,
      money: 85,
      date: '2020-05-20'
    });
  }

  return (
    <BasicPage>
      <div className="analy-content">
        <Form
          {...formItemLayout}
          form={form}
          onFinish={onFinish}
          onFinishFailed={onFinishFailed}
        >
          <Row {...{ gutter: { xs: 8, sm: 16, md: 24 } }}>
            <Col>
              <FormItem label="已购课程名称：" name="courseName">
                <Input
                  placeholder="请输入"
                  onChange={e => {
                    set_courseName(e.target.value);
                  }}
                />
              </FormItem>
            </Col>
            <Col>
              <FormItem label="用户姓名：" name="userName">
                <Input
                  placeholder="请输入"
                  onChange={e => {
                    set_userName(e.target.value);
                  }}
                />
              </FormItem>
            </Col>
            <Col>
              <FormItem label="下单时间：" name="dates">
                <RangePicker
                  locale={locale}
                  onCalendarChange={value => {
                    setDates(value);
                  }}
                />
              </FormItem>
            </Col>
          </Row>
          <Row
            style={{ padding: '12px 0' }}
            {...{ gutter: { xs: 8, sm: 16, md: 24 } }}
          >
            <Col md={12} sm={24}>
              <Button
                type="primary"
                style={{ marginRight: '12px' }}
                onClick={download}
              >
                导出订单信息表
              </Button>
            </Col>
            <Col md={12} sm={24} style={{ textAlign: 'right' }}>
              <Form.Item>
                <Button
                  type="primary"
                  htmlType="submit"
                  style={{ marginRight: '12px' }}
                >
                  查询
                </Button>
                <Button htmlType="button" onClick={resetData}>
                  重置
                </Button>
              </Form.Item>
            </Col>
          </Row>
        </Form>
      </div>
      <List dataSource={dataSource} handleTableChange={handleTableChange} />
    </BasicPage>
  );
};

export default Order;
