import React from 'react';
import { Table } from 'antd';
const { Column } = Table;

interface DeatilI {
  id: string | number;
  order_no: string | number;
  class_name: string | number;
  address: () => {};
  pay: string | number;
  redeem: string | number;
  type: string | number;
  pay_time: string;
}

interface ColsI {
  title: string;
  dataIndex: string;
  key: string | number;
}

interface DataSourceI {
  dataSource: DeatilI[];
  pageSize: number;
  current: number;
  totalCount: number;
  handleTableChange: any;
}

const columns = [
  {
    title: '订单号',
    dataIndex: 'order_no',
    key: 'order_no'
  },
  {
    title: '已购课程名称',
    dataIndex: 'class_name',
    key: 'class_name'
  },
  {
    title: '用户姓名',
    dataIndex: 'address',
    key: 'address',
    render: (row: any) => {
      return <span>{row.name}</span>;
    }
  },
  {
    title: '收货地址',
    dataIndex: 'address',
    key: 'address',
    render: (row: any) => {
      return (
        <span>
          {row.province}
          {row.city}
          {row.area}
          {row.address}
        </span>
      );
    }
  },
  {
    title: '联系电话',
    dataIndex: 'address',
    key: 'address',
    render: (row: any) => {
      return <span>{row.phone}</span>;
    }
  },
  {
    title: '支付方式',
    dataIndex: 'type',
    key: 'type',
    render: (row: any) => {
      return <span>{row === 1 ? '微信' : '兑换码'}</span>;
    }
  },
  {
    title: '兑换码',
    dataIndex: 'redeem',
    key: 'redeem'
  },
  {
    title: '付款金额（元）',
    dataIndex: 'pay',
    key: 'pay'
  },
  {
    title: '下单时间',
    dataIndex: 'pay_time',
    key: 'pay_time'
  }
];

const Cols = (list: ColsI[]) => {
  return list.map((item: any) => {
    return <Column {...item} key={item.key} />;
  });
};

const List: React.FC<DataSourceI> = props => {
  return (
    <div style={{ padding: '30px' }}>
      <Table
        rowKey={record => record.id || 'key'}
        dataSource={props.dataSource}
        onChange={props.handleTableChange}
        pagination={{
          pageSize: props.pageSize,
          current: props.current,
          total: props.totalCount,
          showSizeChanger: true,
          showTotal: (total, range) =>
            `每页${range[1] - range[0] + 1}条，总计${total} 条`
        }}
      >
        {Cols(columns)}
      </Table>
    </div>
  );
};

export default List;
