import React from 'react';
import { Table } from 'antd';
const { Column } = Table;

interface DeatilI {
  id: string | number;
  orderNumber: string | number;
  courseName: string | number;
  userName: string | number;
  address: string;
  phone: string | number;
  money: string | number;
  date: string;
}

interface ColsI {
  title: string;
  dataIndex: string;
  key: string | number;
}

interface DataSourceI {
  dataSource: DeatilI[];
  pageSize: number;
  current: number;
  handleTableChange: any;
}

const columns = [
  {
    title: '订单号',
    dataIndex: 'orderNumber',
    key: 'orderNumber'
  },
  {
    title: '已购课程名称',
    dataIndex: 'courseName',
    key: 'courseName'
  },
  {
    title: '用户姓名',
    dataIndex: 'userName',
    key: 'userName'
  },
  {
    title: '收货地址',
    dataIndex: 'address',
    key: 'address'
  },
  {
    title: '联系电话',
    dataIndex: 'phone',
    key: 'phone'
  },
  {
    title: '付款金额（元）',
    dataIndex: 'money',
    key: 'money'
  },
  {
    title: '下单时间',
    dataIndex: 'date',
    key: 'date'
  }
];

const Cols = (list: ColsI[]) => {
  return list.map((item: any) => {
    return <Column {...item} key={item.key} />;
  });
};

const List: React.FC<DataSourceI> = props => {
  return (
    <div style={{ padding: '30px' }}>
      <Table
        rowKey={record => record.id || 'key'}
        dataSource={props.dataSource}
        onChange={props.handleTableChange}
        pagination={{
          pageSize: props.pageSize,
          current: props.current,
          showSizeChanger: true,
          showTotal: (total, range) =>
            `${range[1] - range[0] + 1} of ${total} items`
        }}
      >
        {Cols(columns)}
      </Table>
    </div>
  );
};

export default List;
