import React, { useState, useEffect } from 'react';
import { Layout, Menu } from 'antd';
import { Link } from 'react-router-dom';
import { createFromIconfontCN } from '@ant-design/icons';

const MyIcon = createFromIconfontCN({
  scriptUrl: '//at.alicdn.com/t/font_n8ucanheuka6pqfr.js' // 在 iconfont.cn 上生成
});

const { Sider } = Layout;
const { SubMenu } = Menu;

interface ConfigI {
  collapsed: boolean;
  pathName: string;
  style?: any;
}

const MenuBar: React.FC<ConfigI> = props => {
  const [defKey, set_defKey] = useState(
    window.localStorage.getItem('menu_defKey') || '1'
  );
  const [openKey, set_openKey] = useState(
    window.localStorage.getItem('menu_openKey') || '1'
  );

  const routerConfStr = window.localStorage.getItem('routerConf') || '';
  if (!routerConfStr) {
    window.location.href = '/inclass/login';
  }
  const routerConf = JSON.parse(routerConfStr);

  // const routerConf = [
  //   {
  //     id: '1',
  //     title: '订单列表',
  //     path: '/orderList',
  //     icon: 'icon-gongdan',
  //     subs: []
  //   },
  //   {
  //     id: '2',
  //     title: '兑换码',
  //     path: '',
  //     icon: 'icon-set',
  //     subs: [
  //       {
  //         id: '3',
  //         title: '兑换码列表',
  //         path: '/exchangeCode',
  //         icon: 'icon-jixiao'
  //       },
  //       {
  //         id: '4',
  //         title: '兑换码生成',
  //         path: '/generateCode',
  //         icon: 'icon-people'
  //       }
  //     ]
  //   }
  // ];

  useEffect(() => {
    matchPath(routerConf);
  }, []);

  const matchPath = (routerConf: any[]) => {
    const curPathName = props.pathName;

    const match = (routeItem: any, defKey: string, openKey: string) => {
      if (routeItem.path === curPathName) {
        set_defKey(defKey);
        set_openKey(openKey);
        window.localStorage.setItem('menu_defKey', defKey);
        window.localStorage.setItem('menu_openKey', openKey);
      }
    };

    routerConf.map(item => {
      if (item.subs.length === 0) {
        match(item, String(item.id), String(item.id));
      }
      if (item.subs.length) {
        item.subs.map((d: any) => {
          match(d, String(d.id), String(item.id));
        });
      }
    });
  };

  const CreateIcon = (type: string) => {
    return <MyIcon type={type} />;
  };

  const CreateItem = (item: any) => {
    return (
      <Menu.Item key={item.id} icon={CreateIcon(item.icon)}>
        <Link to={item.path}>{item.title}</Link>
      </Menu.Item>
    );
  };

  const GererateRouter = () => {
    return routerConf.map((item: any) => {
      if (item.subs && item.subs.length > 0) {
        return (
          <SubMenu
            key={item.id}
            icon={CreateIcon(item.icon)}
            title={item.title}
          >
            {item.subs.map((idx: any) => CreateItem(idx))}
          </SubMenu>
        );
      } else {
        return CreateItem(item);
      }
    });
  };

  const handleClick = (data: any) => {
    set_defKey(data.key);
    let keyPath = data.keyPath[data.keyPath.length - 1];
    set_openKey(keyPath);
    window.localStorage.setItem('menu_defKey', data.key);
    window.localStorage.setItem('menu_openKey', keyPath);
  };

  return (
    <>
      <Sider
        trigger={null}
        collapsible
        collapsed={props.collapsed}
        className="sider-menu"
        style={props.style}
      >
        {props.collapsed ? null : (
          <div className="menu-header">
            <Link to="/orderList" className="home">
              <img
                className="logo"
                src="//r.51gjj.com/webpublic/images/2020523/oyed3Mkrvrpdg.png"
                alt=""
              />
              <div className="title">趣选课合作后台</div>
            </Link>
          </div>
        )}
        <Menu
          theme="dark"
          defaultSelectedKeys={[defKey]}
          defaultOpenKeys={[openKey]}
          selectedKeys={[defKey]}
          mode="inline"
          onClick={handleClick}
        >
          {GererateRouter()}
        </Menu>
      </Sider>
    </>
  );
};
export default MenuBar;
