import React, { useState, useEffect } from 'react';
import { Input, Button, Form, Row, Col } from 'antd';
import { Link } from 'react-router-dom';

import List from './list';
import excelFn from '../../common/excel';
import { api } from '../../common/fetch';
import BasicPage from '../../layout/basicPage';
// style
import './index.scss';

const FormItem = Form.Item;
const PAGE_SIZE = 10;

const ExchangeCode: React.FC = () => {
  const [dataSource, set_dataSource] = useState([]);
  const [totalCount, set_totalCount] = useState(0);

  const [class_name, set_className] = useState('');
  const [page, set_page] = useState(1);
  const [limit, set_limit] = useState(PAGE_SIZE);

  useEffect(() => {
    getList(class_name, page, limit);
  }, []);

  const getList = (class_name: string, page: number, limit: number) => {
    api(`/51business/api/course/back/redeem`, {
      type: 'GET',
      data: {
        class_name: class_name,
        limit: limit,
        page: page
      }
    }).then(r => {
      set_dataSource(r.list);
      set_totalCount(r.total_count);
    });
  };

  const download = () => {
    api('/yizhi_server/api/account/analyse/download', {
      type: 'GET',
      data: {
        product: 'JSON.stringify(info.product)'
      },
      responseType: 'arrayBuffer'
    }).then(r => {
      excelFn(r, `分析明细`);
    });
  };

  const submitData = () => {
    getList(class_name, page, limit);
  };

  const resetData = () => {
    set_className('');
    set_page(1);
    set_limit(PAGE_SIZE);
    getList(class_name, page, limit);
  };

  const handleTableChange = (args: any) => {
    set_page(args.current);
    set_limit(args.pageSize);
    getList(class_name, args.current, args.pageSize);
  };

  return (
    <BasicPage>
      <div className="content">
        <Row {...{ gutter: { xs: 8, sm: 16, md: 24 } }}>
          <Col md={6} sm={12}>
            <FormItem label="已购课程名称：">
              <Input
                value={class_name}
                placeholder="请输入"
                onChange={e => {
                  set_className(e.target.value);
                }}
              />
            </FormItem>
          </Col>
          <Col md={6} sm={12}>
            <Button
              type="primary"
              onClick={submitData}
              style={{ marginRight: '12px' }}
            >
              查询
            </Button>
            <Button htmlType="button" onClick={resetData}>
              重置
            </Button>
          </Col>
        </Row>
        <Row
          style={{ padding: '12px 0' }}
          {...{ gutter: { xs: 8, sm: 16, md: 24 } }}
        >
          <Col md={12} sm={24}>
            <Button type="primary" style={{ marginRight: '12px' }}>
              <Link to="/generateCode">兑换码生成器</Link>
            </Button>
            <Button
              type="primary"
              style={{ marginRight: '12px' }}
              onClick={download}
            >
              导出兑换码数据表
            </Button>
          </Col>
        </Row>
      </div>
      <List
        dataSource={dataSource}
        handleTableChange={handleTableChange}
        pageSize={limit}
        current={page}
        totalCount={totalCount}
      />
    </BasicPage>
  );
};

export default ExchangeCode;
