import React from 'react';
import { Table } from 'antd';
import tableColumnsSetting from './tableColumnsSetting'


interface DeatilI {
  id: string | number;
  order_no: string | number;
  class_name: string | number;
  address: () => {};
  pay: string | number;
  pay_time: string;
}

interface DataSourceI {
  dataSource: DeatilI[];
  pageSize: number;
  current: number;
  totalCount: number;
  handleTableChange: any;
  tableColunmSetting: Array<string>
}
interface IColumnsValue {
  title: string;
  dataIndex: string;
  key: string | number;
  render?: Function
}


const List: React.FC<DataSourceI> = props => {
  const columns: Array<any> = []
  props.tableColunmSetting.map((item) => {
    for (let key in tableColumnsSetting) {
      if (key === item) {
        columns.push(tableColumnsSetting[key])
      }
    }
    return null
  })
  return (
    <div style={{ padding: '30px' }}>
      <Table
        rowKey={record => record.id || 'key'}
        dataSource={props.dataSource}
        onChange={props.handleTableChange}
        pagination={{
          pageSize: props.pageSize,
          current: props.current,
          total: props.totalCount,
          showSizeChanger: true,
          showTotal: (total, range) =>
            `每页${range[1] - range[0] + 1}条，总计${total} 条`
        }}
        columns={columns}
      >

      </Table>
    </div>
  );
};

export default List;
