import React, { useState, useEffect } from 'react';
import { Form, Input, Button, Select, message } from 'antd';
import BasicPage from '../../layout/basicPage';
import { api } from '../../common/fetch';

const { Option } = Select;

const layout = {
  labelCol: { span: 4 },
  wrapperCol: { span: 6 }
};
const tailLayout = {
  wrapperCol: { offset: 4, span: 6 }
};

const GenerateCode: React.FC = () => {
  let curInstitutionName: any =
    window.localStorage.getItem('institution_name') || '';

  const [courseData, set_courseData] = useState([]);
  const [classData, set_classData] = useState([] as any[]);
  const [form] = Form.useForm();

  useEffect(() => {
    getClassData(curInstitutionName);
  }, []);

  const getClassData = (institution_name?: string) => {
    api(`/51business/api/course/back/class`, {
      data: { institution_name, page: 1, limit: 20 },
      type: 'GET'
    }).then((r: any) => {
      set_courseData(r.list);
    });
  };

  const onFinish = (values: any) => {
    api(`/51business/api/course/back/redeem`, {
      type: 'POST',
      data: {
        ...values
      }
    }).then((r: any) => {
      message.success('生成成功');
      form.resetFields();
    });
  };

  const onReset = () => {
    form.resetFields();
  };

  const onChange = (val: any) => {
    form.resetFields(['class_id']);
    let d: any[] = [];
    courseData.map((item: any) => {
      if (item.id === val) {
        d = item.class;
      }
    });
    set_classData(d);
  };
  const onSearch = (val: string) => {
    getClassData(val);
  };
  return (
    <BasicPage>
      <Form {...layout} form={form} name="control-hooks" onFinish={onFinish}>
        <Form.Item
          name="institution"
          label="机构名称："
          rules={[{ required: true, message: '请选择机构' }]}
        >
          <Select
            defaultActiveFirstOption
            placeholder="请选择机构"
            allowClear
            showSearch={!curInstitutionName}
            onChange={onChange}
            onSearch={onSearch}
            filterOption={(input, option: any) =>
              option.children.toLowerCase().indexOf(input.toLowerCase()) >= 0
            }
          >
            {courseData.map((item: any) => {
              return (
                <Option value={item.id} key={item.id}>
                  {item.name}
                </Option>
              );
            })}
          </Select>
        </Form.Item>
        <Form.Item
          name="class_id"
          label="课程名称："
          rules={[{ required: true, message: '请选择课程' }]}
        >
          <Select placeholder="请选择课程名称" allowClear>
            {classData.map((item: any) => {
              return (
                <Option value={item.id} key={item.id}>
                  {item.name}
                </Option>
              );
            })}
          </Select>
        </Form.Item>
        <Form.Item
          name="channel"
          label="渠道名称："
          rules={[
            { required: true, message: '请输入渠道' },
            {
              whitespace: true,
              message: '不能为空格字符'
            }
          ]}
        >
          <Input placeholder="请输入" />
        </Form.Item>
        <Form.Item
          name="num"
          label="兑换码数量："
          rules={[
            { required: true, message: '请输入兑换码数量' },
            {
              whitespace: true,
              message: '不能为空格字符'
            },
            {
              pattern: /^[0-9]+$/,
              message: '仅支持输入数字'
            }
          ]}
        >
          <Input placeholder="请输入" />
        </Form.Item>
        <Form.Item {...tailLayout}>
          <Button type="primary" htmlType="submit">
            生成兑换码
          </Button>
          <Button
            htmlType="button"
            onClick={onReset}
            style={{ marginLeft: '20px' }}
          >
            重置
          </Button>
        </Form.Item>
      </Form>
    </BasicPage>
  );
};

export default GenerateCode;
