import React, { useState, useMemo, useRef } from 'react';
import { Input, message, Button, Modal } from 'antd';
import { UserOutlined, UnlockOutlined } from '@ant-design/icons';
import { withRouter, RouteComponentProps } from 'react-router-dom';
import { api } from '../../common/fetch';
// style
import './index.css';

interface Btn {
  title: string;
}

// login main
const Login: React.FC<RouteComponentProps> = () => {
  const [passport, set_passport] = useState('');
  const [password, set_password] = useState('');
  const [isEnable, set_Enable] = useState(false);
  const [showModal, set_showModal] = useState(false);

  const loginBtnRef = useRef(null);

  const onChangeInp = (e: any, name: string) => {
    let obj: any = {
      passport: (e: string) => {
        set_passport(e);
      },
      password: (e: string) => {
        set_password(e);
      }
    };
    obj[name](e.target.value);
  };
  // 按钮可用
  useMemo(() => {
    if (password && passport) {
      set_Enable(true);
    } else {
      set_Enable(false);
    }
  }, [passport, password]);

  // message 设置
  message.config({
    duration: 2,
    maxCount: 3
  });
  const info = (msg: string) => {
    message.info(msg);
  };
  // 登录按钮
  const LoginBtn: React.FC<Btn & RouteComponentProps> = props => {
    const submit = () => {
      if (isEnable) {
        const { history } = props;
        api('/51business/api/course/back/login', {
          data: {
            account: passport,
            password: password
          },
          error: () => {
            set_password('');
          }
        })
          .then(async res => {
            if (res) {
              window.localStorage.setItem('token', res.auth_token);
              window.localStorage.setItem(
                'institution_name',
                res.institution_name
              );
              window.localStorage.setItem('institution_id', res.institution_id);
              window.localStorage.setItem('user', passport);
              let memuData = await api('/51business/api/course/back/menu', {
                type: 'GET'
              });
              window.localStorage.setItem(
                'routerConf',
                JSON.stringify(memuData.list)
              );
              history.push('/orderList');
            }
          })
          .catch(e => {
            console.log(e);
          });
      } else {
        info('用户名或密码不正确');
      }
    };
    const styleBtn = isEnable
      ? ['btn', 'loginItem', 'btn_act']
      : ['btn', 'loginItem'];
    return (
      <button className={styleBtn.join(' ')} onClick={submit} ref={loginBtnRef}>
        {props.title}
      </button>
    );
  };
  const Btn = withRouter(LoginBtn);

  return (
    <div>
      <div className="loginPane">
        <div className="login-inline">
          <img
            style={{ width: '80%' }}
            src="https://gw.alipayobjects.com/mdn/rms_ae7ad9/afts/img/A*-wAhRYnWQscAAAAAAAAAAABkARQnAQ"
            alt=""
          />
        </div>

        <div className="login-inline">
          <div>
            <h3
              style={{
                textAlign: 'center',
                fontSize: '24px',
                fontWeight: 'bold'
              }}
            >
              趣选课合作后台
            </h3>
          </div>
          <div className="loginItem">
            <Input
              size="large"
              placeholder="请输入你的账号"
              value={passport}
              onChange={(e: any) => onChangeInp(e, 'passport')}
              prefix={<UserOutlined className="site-form-item-icon" />}
            />
          </div>
          <div className="loginItem">
            <Input.Password
              size="large"
              placeholder="请输入你的密码"
              value={password}
              autoComplete="new-password"
              onPressEnter={() => {
                let cur = loginBtnRef.current;
                console.log(cur);
              }}
              onChange={(e: any) => onChangeInp(e, 'password')}
              prefix={<UnlockOutlined />}
            />
          </div>
          <Btn title="登录" />
          <Button type="link" onClick={() => set_showModal(true)}>
            忘记密码
          </Button>
          <Modal
            title="忘记密码"
            width="300px"
            visible={showModal}
            footer={
              <Button
                type="primary"
                size="large"
                block
                onClick={() => set_showModal(false)}
              >
                登录
              </Button>
            }
            onCancel={() => set_showModal(false)}
          >
            <p style={{ fontSize: '16px' }}>请联系51公积金同事进行密码重置</p>
          </Modal>
        </div>
      </div>
    </div>
  );
};
export default Login;
