import React, { useState, useEffect } from 'react';
import locale from 'antd/es/date-picker/locale/zh_CN';
import moment from 'moment';
import { Input, Button, Form, DatePicker, Row, Col } from 'antd';
import 'moment/locale/zh-cn';

import List from './list';
import BasicPage from '../../layout/basicPage';
import excelFn from '../../common/excel';
import { api } from '../../common/fetch';
// style
import './index.scss';

const FormItem = Form.Item;
const { RangePicker } = DatePicker;
moment.locale('zh-cn');

const PAGE_SIZE = 10;

interface FilterData {
  class_name?: string;
  user_name?: string;
  start_time?: string;
  end_time?: string;
  current?: number;
  limit?: number;
}
interface ITableColumns {
  column: string,
  title: string
}

const OrderList: React.FC = () => {
  const [class_name, set_className] = useState('');
  const [user_name, set_userName] = useState('');
  const [start_time, set_startTime] = useState('');
  const [end_time, set_endTime] = useState('');

  const [dataSource, set_dataSource] = useState([]);
  const [totalCount, set_totalCount] = useState(0);
  const [current, set_current] = useState(1);
  const [limit, set_limit] = useState(PAGE_SIZE);
  const [tableColunmSetting, setTableColunmSetting] = useState<Array<string>>([])

  const [form] = Form.useForm();
  const formItemLayout = {
    labelCol: {
      xs: { span: 24 },
      sm: { span: 10 },
      md: { span: 10 }
    },
    wrapperCol: {
      xs: { span: 24 },
      sm: { span: 18 },
      md: { span: 18 }
    }
  };

  useEffect(() => {
    getList({
      class_name,
      user_name,
      start_time,
      end_time,
      current,
      limit
    });
    getTableColumnSetting()
  }, []);

  const getTableColumnSetting = () => {
    api(`/51business/api/course/back/column/all`, {
      type: 'GET',
      data: {}
    }).then(res => {
      console.log(res)
      let list: Array<string> = []
      if (res && res.list && res.list.length > 0) {
        res.list.map((item: ITableColumns) => {
          list.push(item.column)
          return null
        })
      } else {
        list = ['order_no', 'class_name', 'pay', 'pay_time']
      }
      setTableColunmSetting(list)
    });
  }

  const getList = ({
    class_name = '',
    user_name = '',
    start_time = '',
    end_time = '',
    current = 1,
    limit = PAGE_SIZE
  }: FilterData) => {
    api(`/51business/api/course/back/order`, {
      type: 'GET',
      data: {
        class_name,
        user_name,
        start_time: start_time ? start_time + ' 00:00:00' : '',
        end_time: end_time ? end_time + ' 23:59:59' : '',
        page: current,
        limit: limit
      }
    }).then(r => {
      set_dataSource(r.list);
      set_totalCount(r.total_count);
    });
  };

  const download = () => {
    api('/51business/api/course/back/export/order', {
      type: 'GET',
      data: {
        class_name,
        user_name,
        start_time: start_time ? start_time + ' 00:00:00' : '',
        end_time: end_time ? end_time + ' 23:59:59' : ''
      },
      responseType: 'arrayBuffer'
    }).then(r => {
      excelFn(r, `购买订单列表${start_time}_${end_time}`);
    });
  };

  const changeValue = (type: string, val: any) => {
    let obj: any = {
      class_name: () => set_className(val),
      user_name: () => set_userName(val),
      dates: () => {
        let start_time = (val && moment(val[0]).format('YYYY-MM-DD')) || '';
        let end_time = (val && moment(val[1]).format('YYYY-MM-DD')) || '';
        set_startTime(start_time);
        set_endTime(end_time);
      }
    };
    obj[type] && obj[type]();
  };

  const resetData = () => {
    form.resetFields();
    changeValue('class_name', '');
    changeValue('user_name', '');
    set_current(1);
    set_limit(PAGE_SIZE);
    getList({});
  };

  const handleTableChange = (args: any) => {
    set_current(args.current);
    set_limit(args.pageSize);
    getList({
      class_name,
      user_name,
      start_time,
      end_time,
      current: args.current,
      limit: args.pageSize
    });
  };

  const onFinish = () => {
    set_current(1);
    set_limit(PAGE_SIZE);
    getList({
      class_name,
      user_name,
      start_time,
      end_time,
      current: 1,
      limit: PAGE_SIZE
    });
  };

  return (
    <BasicPage>
      <div className="analy-content">
        <Form {...formItemLayout} form={form} onFinish={onFinish}>
          <div className="operate-content">
            <div className="form-item">
              <FormItem label="已购课程名称：" name="class_name">
                <Input
                  placeholder="请输入"
                  onChange={e => {
                    changeValue('class_name', e.target.value);
                  }}
                />
              </FormItem>
            </div>
            <div className="form-item">
              <FormItem label="用户姓名：" name="userName">
                <Input
                  placeholder="请输入"
                  onChange={e => {
                    changeValue('user_name', e.target.value);
                  }}
                />
              </FormItem>
            </div>
            <div className="form-item">
              <FormItem label="下单时间：" name="dates">
                <RangePicker
                  locale={locale}
                  onCalendarChange={value => {
                    changeValue('dates', value);
                  }}
                />
              </FormItem>
            </div>
            <div className="search-group">
              <Form.Item>
                <Button
                  type="primary"
                  htmlType="submit"
                  style={{ marginRight: '12px' }}
                >
                  查询
            </Button>
                <Button htmlType="button" onClick={resetData}>
                  重置
            </Button>
              </Form.Item>
            </div>
          </div>

          <div className="export">
            <Button
              type="primary"
              style={{ marginRight: '30px' }}
              onClick={download}
            >
              导出订单信息表
          </Button>
          </div>

        </Form>
      </div>
      <List
        dataSource={dataSource}
        pageSize={limit}
        current={current}
        totalCount={totalCount}
        handleTableChange={handleTableChange}
        tableColunmSetting={tableColunmSetting}
      />
    </BasicPage>
  );
};

export default OrderList;
