import React from 'react'
interface IObjectStringKeys {
  [key: string]: IColumnsValue;
}
interface IColumnsValue {
  title: string;
  dataIndex: string;
  key: string | number;
  render?: Function
}
const TableColumnsSetting: IObjectStringKeys = {
  order_no: {
    title: '订单号',
    dataIndex: 'order_no',
    key: 'order_no'
  },
  class_name: {
    title: '已购课程名称',
    dataIndex: 'class_name',
    key: 'class_name'
  },
  name: {
    title: '用户姓名',
    dataIndex: 'address',
    key: 'name',
    render: (row: any) => {
      return <span>{row.name ? row.name : '--'}</span>;
    }
  },
  address_name: {
    title: '用户姓名(收货人)',
    dataIndex: 'address',
    key: 'name',
    render: (row: any) => {
      return <span>{row.name ? row.name : '--'}</span>;
    }
  },
  address: {
    title: '收货地址',
    dataIndex: 'address',
    key: 'address',
    render: (row: any) => {
      const address = `${row.province ? row.province : ''}${row.city ? row.city : ''}${row.area ? row.area : ''}${row.address ? row.address : ''}`
      return (
        <span>
          {
            address ? address : '--'
          }
        </span>
      );
    }
  },
  phone: {
    title: '联系电话',
    dataIndex: 'address',
    key: 'phone',
    render: (row: any) => {
      return <span>{row.phone ? row.phone : '--'}</span>;
    }
  },
  pay: {
    title: '付款金额（元）',
    dataIndex: 'pay',
    key: 'pay'
  },
  pay_time: {
    title: '下单时间',
    dataIndex: 'pay_time',
    key: 'pay_time'
  },
  child_name: {
    title: '孩子姓名',
    dataIndex: 'columns',
    key: 'child_name',
    render: (row: any) => {
      return <span>{row.child_name ? row.child_name : '--'}</span>;
    }
  },
  child_age: {
    title: '孩子年龄',
    dataIndex: 'columns',
    key: 'child_age',
    render: (row: any) => {
      return <span>{row.child_age ? row.child_age : '--'}</span>;
    }
  },
  child_grade: {
    title: '孩子年级',
    dataIndex: 'columns',
    key: 'child_grade',
    render: (row: any) => {
      return <span>{row.child_grade ? row.child_grade : '--'}</span>;
    }
  },
  city: {
    title: '所在城市',
    dataIndex: 'columns',
    key: 'city',
    render: (row: any) => {
      return <span>{row.city ? row.city : '--'}</span>;
    }
  }
}

export default TableColumnsSetting