import React from 'react';
import { Route, withRouter, Switch } from 'react-router-dom';

import OrderList from '../pages/orderList/index';
import ExchangeCode from '../pages/exchangeCode/index';
import GenerateCode from '../pages/generateCode/index';
import ExchangeList from '../pages/exchangeList/index';
import Login from '../pages/login/index';

const RouterChild = withRouter(() => {
  return (
    <Switch>
      <Route path="/login" exact component={Login} />
      <Route path="/orderList" exact component={OrderList} />
      <Route path="/exchangeCode" exact component={ExchangeCode} />
      <Route path="/generateCode" exact component={GenerateCode} />
      <Route path="/exchangeList" exact component={ExchangeList} />
      <Route path="/" component={OrderList} />
    </Switch>
  );
});

const BaseRoute: React.FC = () => {
  return <RouterChild />;
};

export default BaseRoute;
