import fetch from 'cross-fetch';
import { message } from 'antd';
type CB = (request: any, res: any) => any;
interface Options {
  type?: string;
  header?: any;
  data?: any;
  [key: string]: any;
}

const formate = (type: string, data: any) => {
  if (type === 'get') {
    let str = '';
    for (let i in data) {
      str += `${i}=${data[i]}&`;
    }
    return str.substr(0, str.length - 1);
  } else {
    return JSON.stringify(data);
  }
};
export function api(url: string, options: Options) {
  let host = window.location.host;
  let type = options.type || 'POST';
  let u = host.match(/(127.0.0.1|localhost)/)
    ? `https://uat-nginx.jianbing.com${url}`
    : url;

  u = type === 'GET' ? `${u}?${formate('get', options.data)}` : u;

  return fetch(u, {
    method: type,
    headers: {
      'Content-Type': 'application/json;charset=utf-8',
      Authorization: window.localStorage.getItem('token'),
      ...options.header
    },
    body: type === 'GET' ? '' : formate('post', options.data)
  })
    .then((res: any) => {
      if (res.status === 200) {
        if (options.responseType) {
          return res[options.responseType]();
        }
        return res.json();
      } else if (res.status.toString().match(/40./)) {
        res.json().then((r: any) => {
          let msg = r.error || r.msg || 'error';
          message.error(msg);
          // if (r.error) {
          //   if (r.error.match(/token/)) {
          //     message.error('登录过期，请重新登录');
          //     window.location.href = '/inclass/login';
          //   }
          // }
          // if (options.error && typeof options.error === 'function') {
          //   options.error(r);
          // }
        });
      }
    })
    .catch(e => {
      return new Error(e);
    });
}
