import React from 'react';
import { Table } from 'antd';
const { Column } = Table;

interface DeatilI {
  id: string | number;
  courseName: string | number;
  code: string | number;
  status: string | number;
  date: string;
}

interface ColsI {
  title: string;
  dataIndex: string;
  key: string | number;
}

interface DataSourceI {
  dataSource: DeatilI[];
  pageSize: number;
  current: number;
  totalCount: number;
  handleTableChange: any;
}

const columns = [
  {
    title: '课程ID',
    dataIndex: 'id',
    key: 'id'
  },
  {
    title: '课程名称',
    dataIndex: 'courseName',
    key: 'courseName'
  },
  {
    title: '兑换码',
    dataIndex: 'code',
    key: 'code'
  },
  {
    title: '兑换情况',
    dataIndex: 'status',
    key: 'status'
  },
  {
    title: '兑换时间',
    dataIndex: 'date',
    key: 'date'
  }
];

const Cols = (list: ColsI[]) => {
  return list.map((item: any) => {
    return <Column {...item} key={item.key} />;
  });
};

const List: React.FC<DataSourceI> = props => {
  return (
    <div style={{ padding: '30px' }}>
      <Table
        dataSource={props.dataSource}
        rowKey={record => record.id || 'key'}
        onChange={props.handleTableChange}
        pagination={{
          pageSize: props.pageSize,
          current: props.current,
          showSizeChanger: true,
          showTotal: (total, range) =>
            `${range[1] - range[0] + 1} of ${total} items`
        }}
      >
        {Cols(columns)}
      </Table>
    </div>
  );
};

export default List;
