import React from 'react';
import { Form, Input, Button, Select, message } from 'antd';
import BasicPage from '../../layout/basicPage';
import { api } from '../../common/fetch';

const { Option } = Select;

const layout = {
  labelCol: { span: 4 },
  wrapperCol: { span: 6 }
};
const tailLayout = {
  wrapperCol: { offset: 4, span: 6 }
};

const GenerateCode: React.FC = () => {
  const [form] = Form.useForm();

  const onFinish = (values: any) => {
    api(`/51business/api/course/back/redeem`, {
      type: 'POST',
      data: {
        ...values
      }
    }).then((r: any) => {
      message.success('生成成功');
      form.resetFields();
    });
  };

  const onReset = () => {
    form.resetFields();
  };

  const It = [
    {
      name: '趣选课',
      id: 1
    },
    {
      name: '我连网',
      id: 2
    }
  ];

  return (
    <BasicPage>
      <Form {...layout} form={form} name="control-hooks" onFinish={onFinish}>
        {/* <Form.Item
          name="institution"
          label="机构名称："
          rules={[{ required: true, message: '请选择机构' }]}
        >
          <Select placeholder="请选择机构" allowClear>
            {It.map(item => {
              return (
                <Option value={item.id} key={item.id}>
                  {item.name}
                </Option>
              );
            })}
          </Select>
        </Form.Item> */}
        <Form.Item
          name="class_id"
          label="课程名称："
          rules={[{ required: true, message: '请选择课程' }]}
        >
          <Select placeholder="请选择课程名称" allowClear>
            {It.map(item => {
              return (
                <Option value={item.id} key={item.id}>
                  {item.name}
                </Option>
              );
            })}
          </Select>
        </Form.Item>
        <Form.Item
          name="channel"
          label="渠道名称："
          rules={[
            { required: true, message: '请输入渠道' },
            {
              whitespace: true,
              message: '不能为空格字符'
            }
          ]}
        >
          <Input placeholder="请输入" />
        </Form.Item>
        <Form.Item
          name="num"
          label="兑换码数量："
          rules={[
            { required: true, message: '请输入兑换码数量' },
            {
              whitespace: true,
              message: '不能为空格字符'
            },
            {
              pattern: /^[0-9]+$/,
              message: '仅支持输入数字'
            }
          ]}
        >
          <Input placeholder="请输入" />
        </Form.Item>
        <Form.Item {...tailLayout}>
          <Button type="primary" htmlType="submit">
            生成兑换码
          </Button>
          <Button
            htmlType="button"
            onClick={onReset}
            style={{ marginLeft: '20px' }}
          >
            重置
          </Button>
        </Form.Item>
      </Form>
    </BasicPage>
  );
};

export default GenerateCode;
