import React, { useState, useEffect } from 'react';
import locale from 'antd/es/date-picker/locale/zh_CN';
import moment from 'moment';
import { Input, Button, Form, DatePicker, Row, Col } from 'antd';
import 'moment/locale/zh-cn';

import List from './list';
import BasicPage from '../../layout/basicPage';
import excelFn from '../../common/excel';
import { api } from '../../common/fetch';
// style
import './index.scss';

const FormItem = Form.Item;
const { RangePicker } = DatePicker;
moment.locale('zh-cn');

const PAGE_SIZE = 2;

interface FilterData {
  class_name?: string;
  user_name?: string;
  start_date?: string;
  end_date?: string;
  current?: number;
  limit?: number;
}

const OrderList: React.FC = () => {
  const [class_name, set_className] = useState('');
  const [user_name, set_userName] = useState('');
  const [start_date, set_startDate] = useState('');
  const [end_date, set_endDate] = useState('');

  const [dataSource, set_dataSource] = useState([]);
  const [totalCount, set_totalCount] = useState(0);
  const [current, set_current] = useState(1);
  const [limit, set_limit] = useState(PAGE_SIZE);

  const [form] = Form.useForm();
  const formItemLayout = {
    labelCol: {
      xs: { span: 24 },
      sm: { span: 10 },
      md: { span: 10 }
    },
    wrapperCol: {
      xs: { span: 24 },
      sm: { span: 18 },
      md: { span: 18 }
    }
  };

  useEffect(() => {
    getList({
      class_name,
      user_name,
      start_date,
      end_date,
      current,
      limit
    });
  }, []);

  const getList = ({
    class_name = '',
    user_name = '',
    start_date = '',
    end_date = '',
    current = 1,
    limit = PAGE_SIZE
  }: FilterData) => {
    api(`/51business/api/course/back/order`, {
      type: 'GET',
      data: {
        // class_name,
        // user_name,
        // start_date,
        // end_date,
        page: current,
        limit: limit
      }
    }).then(r => {
      console.log(r);
      set_dataSource(r.list);
      set_totalCount(r.total_count);
    });
  };

  const download = () => {
    api('/yizhi_server/api/account/analyse/download', {
      type: 'GET',
      data: {
        class_name,
        user_name,
        start_date,
        end_date,
        product: 'JSON.stringify(info.product)'
      },
      responseType: 'arrayBuffer'
    }).then(r => {
      excelFn(r, `分析明细${start_date}_${end_date}`);
    });
  };

  const changeValue = (type: string, val: any) => {
    let obj: any = {
      class_name: () => set_className(val),
      user_name: () => set_userName(val),
      dates: () => {
        let start_date = (val && moment(val[0]).format('YYYY-MM-DD')) || '';
        let end_date = (val && moment(val[1]).format('YYYY-MM-DD')) || '';
        set_startDate(start_date);
        set_endDate(end_date);
      }
    };
    obj[type] && obj[type]();
  };

  const resetData = () => {
    form.resetFields();
    changeValue('class_name', '');
    changeValue('user_name', '');
    set_current(1);
    set_limit(PAGE_SIZE);
    getList({});
  };

  const handleTableChange = (args: any) => {
    set_current(args.current);
    set_limit(args.pageSize);
    getList({
      class_name,
      user_name,
      start_date,
      end_date,
      current: args.current,
      limit: args.pageSize
    });
  };

  const onFinish = () => {
    set_current(1);
    set_limit(PAGE_SIZE);
    getList({
      class_name,
      user_name,
      start_date,
      end_date,
      current: 1,
      limit: PAGE_SIZE
    });
  };

  return (
    <BasicPage>
      <div className="analy-content">
        <Form {...formItemLayout} form={form} onFinish={onFinish}>
          <Row {...{ gutter: { xs: 8, sm: 16, md: 24 } }}>
            <Col span="6">
              <FormItem label="已购课程名称：" name="class_name">
                <Input
                  placeholder="请输入"
                  onChange={e => {
                    changeValue('class_name', e.target.value);
                  }}
                />
              </FormItem>
            </Col>
            <Col span="6">
              <FormItem label="用户姓名：" name="userName">
                <Input
                  placeholder="请输入"
                  onChange={e => {
                    changeValue('userName', e.target.value);
                  }}
                />
              </FormItem>
            </Col>
            <Col span="6">
              <FormItem label="下单时间：" name="dates">
                <RangePicker
                  locale={locale}
                  onCalendarChange={value => {
                    changeValue('dates', value);
                  }}
                />
              </FormItem>
            </Col>
          </Row>
          <Row
            style={{ padding: '12px 0' }}
            {...{ gutter: { xs: 8, sm: 16, md: 24 } }}
          >
            <Col md={12} sm={24}>
              <Button
                type="primary"
                style={{ marginRight: '12px' }}
                onClick={download}
              >
                导出订单信息表
              </Button>
            </Col>
            <Col md={12} sm={24} style={{ textAlign: 'right' }}>
              <Form.Item>
                <Button
                  type="primary"
                  htmlType="submit"
                  style={{ marginRight: '12px' }}
                >
                  查询
                </Button>
                <Button htmlType="button" onClick={resetData}>
                  重置
                </Button>
              </Form.Item>
            </Col>
          </Row>
        </Form>
      </div>
      <List
        dataSource={dataSource}
        pageSize={limit}
        current={current}
        totalCount={totalCount}
        handleTableChange={handleTableChange}
      />
    </BasicPage>
  );
};

export default OrderList;
