import { Context } from 'egg';
import { get } from 'lodash';

export default {
  get userId(this: Context): number | string | null{
    const { app: { config: { jwt: options }} } = this;
    const property = options.property || options.userProperty || "user";
    const data = get(this.state, property);
    return (data && data.userId) || null;
  },
  isAjax(this: Context) {
    return this.get('X-Requested-With') === 'XMLHttpRequest';
  },
  failed(this: Context, message: string, code?: number) {
    const error: any = new Error(message);
    error.code = code || -1;
    this.throw(error, 422);
  }
}