import { Context, Application } from 'egg';
import { get } from 'lodash';

function match(expr, text) {
  if (!/\*/.test(expr)) {
    return text === expr;
  }
  const pattern = '^' + expr
    .replace(/\//gi, '\\/')
    .replace(/\*\*/gi, '(?:[a-zA-Z_0-9\-\/]+)')
    .replace(/\*/gi, '(?:[a-zA-Z_0-9\-]+)') + '$';
  return new RegExp(pattern).test(text);
}

// 这里是你自定义的中间件
export default function middleware(options: any, app: Application): any {
  return async (ctx: Context, next: () => Promise<any>) => {
    const { request } = ctx;
    /**
     * 路径找不到就不判断权限
     */
    if (!app.router.match(request.path, request.method).route) {
      await next();
      return;
    }
    if (options.exclude) {
      if (options.exclude.filter(item => match(`${app.config.router.prefix}${item}`, request.path)).length) {
        app.logger.info(`[middleware-auth] ignore url ${request.url}`);
        await next();
        return;
      }
    }
    const property = options.property || options.userProperty || "user";
    const data = get(ctx.state, property);
    if (!data || !data.userId) {
      ctx.throw('Forbidden', 403);
    }
    await next();
  };
}