import { Controller } from 'egg';
import router from 'egg-router-decorator';

@router.prefix('/')
export default class HomeController extends Controller {

  @router.get('')
  public async index() {
    this.ctx.body = 'hello word';
  }

  @router.get('mock_login/:id')
  public async mockLogin() {
    const { ctx } = this;
    ctx.validate({
      id: {
        type: 'intString'
      }
    }, ctx.params);
    const userId = +ctx.params.id;
    const token = await ctx.service.jwt.genToken(userId);
    this.ctx.body = { token };
  }
}