'use strict';

import { EggAppConfig, PowerPartial } from 'egg';
import * as fs from 'fs';
import * as path from 'path';

// for config.{env}.ts
export type DefaultConfig = PowerPartial<EggAppConfig & MyAppConfig>;

// app special config scheme
export interface MyAppConfig {
  router: {
    prefix: string
  }
}

export default (appInfo: EggAppConfig) => {
  const config = {} as PowerPartial<EggAppConfig> & MyAppConfig;

  config.security = {
    csrf: {
      enable: false,
    },
    domainWhiteList: [],
  };

  config.router = {
    prefix: '{{ pathPrefix }}'
  };

  config.middleware = [
    'auth',
  ];

  config.auth = {
    exclude: [
      '/',
      '/mock_login/*'
    ],
  };

  // override config from framework / plugin
  config.keys = '{{ keys }}';

  config.sessionExpireIn = 7 * 3600 * 24;

  config.jwt = {
    secret: '{{ jwtSecret }}',
    enable: true,
    credentialsRequired: false,
    exp: Math.floor(Date.now() / 1000) + config.sessionExpireIn, // 一周
    getToken(ctx) {
      const parts = ctx.get('authorization').split(' ');
      if (parts.length === 2) {
        const scheme = parts[0];
        const credentials = parts[1];

        if (/^Bearer$/i.test(scheme)) {
          return credentials;
        }
      }
      const { session_token: token } = ctx.request.query;
      return token;
    },
  };

  config.onerror = {
    appErrorFilter: err => {
      if (err.status && Math.floor(err.status / 100) === 4) {
        return false;
      }
      return true;
    },
    accepts: () => 'json',
  };

  config.view = {
    defaultViewEngine: 'nunjucks',
    mapping: {
      '.tpl': 'nunjucks',
    },
  };

  config.siteFile = {
    '/favicon.ico': fs.readFileSync(path.join(appInfo.baseDir, 'app/public/favicon.png')),
  };

  return config;
};
